//
//  Control_FunViewController.m
//  Control Fun
//
//  Created by Robert Górczyński on 11-06-13.
//

#import "Control_FunViewController.h"

@implementation Control_FunViewController

@synthesize nameField;
@synthesize numberField;
@synthesize sliderLabel;
@synthesize leftSwitch; 
@synthesize rightSwitch; 
@synthesize doSomethingButton; 


- (void)viewDidLoad 
{ 
    UIImage *buttonImageNormal = [UIImage imageNamed:@"whiteButton.png"]; 
    UIImage *stretchableButtonImageNormal = [buttonImageNormal 
											 stretchableImageWithLeftCapWidth:12 topCapHeight:0]; 
    [doSomethingButton setBackgroundImage:stretchableButtonImageNormal 
								 forState:UIControlStateNormal]; 
	
    UIImage *buttonImagePressed = [UIImage imageNamed:@"blueButton.png"]; 
    UIImage *stretchableButtonImagePressed = [buttonImagePressed 
											  stretchableImageWithLeftCapWidth:12 topCapHeight:0]; 
	[doSomethingButton setBackgroundImage:stretchableButtonImagePressed 
								 forState:UIControlStateHighlighted]; 
}

- (IBAction)toggleControls:(id)sender { 
    if ([sender selectedSegmentIndex] == kSwitchesSegmentIndex) 
    { 
        leftSwitch.hidden = NO; 
        rightSwitch.hidden = NO; 
        doSomethingButton.hidden = YES; 
    } 
    else 
    { 
        leftSwitch.hidden = YES; 
        rightSwitch.hidden = YES; 
        doSomethingButton.hidden = NO; 
    } 
} 

- (IBAction)switchChanged:(id)sender { 
    UISwitch *whichSwitch = (UISwitch *)sender; 
    BOOL setting = whichSwitch.isOn; 
    [leftSwitch setOn:setting animated:YES]; 
    [rightSwitch setOn:setting animated:YES]; 
} 

- (IBAction)buttonPressed {
    // TODO: Implementacja elementu Action Sheet oraz komunikatu
    UIActionSheet *actionSheet = [[UIActionSheet alloc]
                                  initWithTitle:@"Czy jesteś pewny?"
                                  delegate:self
                                  cancelButtonTitle:@"Nie ma mowy!"
                                  destructiveButtonTitle:@"Tak, jestem pewny!"
                                  otherButtonTitles:nil];
    [actionSheet showInView:self.view];
    [actionSheet release];
}

- (void)actionSheet:(UIActionSheet *)actionSheet 
didDismissWithButtonIndex:(NSInteger)buttonIndex 
{ 
    if (buttonIndex != [actionSheet cancelButtonIndex])
    { 
		NSString *msg = nil;
		if (nameField.text.length > 0)
			msg = [[NSString alloc] initWithFormat:
				   @"%@, możesz się uspokoić, wszystko w porządku.",
				   nameField.text];
		else
			msg = @"Możesz się uspokoić, wszystko w porządku.";
		UIAlertView *alert = [[UIAlertView alloc]
							  initWithTitle:@"Wykonano pewną operację"
							  message:msg
							  delegate:self
							  cancelButtonTitle:@"Pikuś!"
							  otherButtonTitles:nil];
		[alert show];
		[alert release];
		[msg release];
    }
}

- (IBAction)sliderChanged:(id)sender { 
    UISlider *slider = (UISlider *)sender; 
    int progressAsInt = (int)(slider.value + 0.5f); 
    NSString *newText = [[NSString alloc] initWithFormat:@"%d", 
						 progressAsInt]; 
    sliderLabel.text = newText; 
    [newText release]; 
} 

- (IBAction)backgroundTap:(id)sender {
	[nameField resignFirstResponder];
    [numberField resignFirstResponder];
}

- (IBAction)textFieldDoneEditing:(id)sender {
	[sender resignFirstResponder];
}

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
    self.nameField = nil;
    self.numberField = nil;
    self.sliderLabel = nil;
    self.leftSwitch = nil;
    self.rightSwitch = nil;
    self.doSomethingButton = nil;
	
    [super viewDidUnload];
}

- (void)dealloc {
    [nameField release];
	[numberField release];
    [sliderLabel release];
	[leftSwitch release];
    [rightSwitch release];
    [doSomethingButton release];	
	[super dealloc];
}

@end
